	function alfa = RICHARDS_REACTANCE_WDF(Num, Den)
	%
	% 	Computes the adaptor coefficients in a Richards' WDF structure   
	%	consisting of cascaded lossless commensurate transmission lines 
	%	for an impedance Z = Num/Den, where Num and Den are polynomials 
	%	in Psi, where Psi is Richards' variable. For example, Num = [1 2 3]
	%	correspond to Num = 1 + 2Psi + 3Psi^2.
	%	The last transmission line is either open-circuited, 
	%	short-circuited, or resistively terminated.
	%
	%	The vector Z contains the characteristic impedances for the  
	%	transmission lines and a possible resistive termination, RL, 
	%	is given separately.	 
	%	K is a vector used by LADDER_2_H that defines the two-ports.
	
	%	Toolbox for ANALOG FILTERS USING MATLAB
	
	% 	Author: 			Lars Wanhammar, 2008-11-17
	% 	Modified by: 	 	
	%	Copyright:			Divison of Electronics Systems
	%	 					Dept. Electrical Engineering, Linkoping University, Sweden
	% 	Version:			1 
	% 	Known bugs:	 
	% 	Report bugs to:		Wanhammar@gmail.com
	
	[Z, K, RL] = RICHARDS_REACTANCE(Num, Den);
	Z = cat(2,[1], Z);
	if RL ~= inf, Z = cat(2, Z, [RL]); end
	for k = 1:length(Z)-1
		alfa(k) = (Z(k)-Z(k+1))/(Z(k)+Z(k+1));
	end
